#ifndef _INIT_CPP
#define _INIT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"

#include "../../SharedSource/NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool InitializeApp(void)
{
    LoadString(ghAppInstance, IDS_APPCOPYRIGHT, gsAppCopyRight, sizeof(gsAppCopyRight));
    LoadString(ghAppInstance, IDS_FILEVERSION, gsFileVersion, sizeof(gsFileVersion));
    LoadString(ghAppInstance, IDS_TITLECAPTION, gsTitleCaption, sizeof(gsTitleCaption));
    LoadString(ghAppInstance, IDS_REGISTRYKEY, gsRegistryKey, sizeof(gsRegistryKey));

    INITCOMMONCONTROLSEX ICCEX;
    ICCEX.dwSize = sizeof(ICCEX);
    ICCEX.dwICC  = ICC_DATE_CLASSES;
    InitCommonControlsEx(&ICCEX);

	InitializeCRCTable();

	memset(&MDI, 0, sizeof(MDI));
	memset(&gServer, 0, sizeof(gServer));

	if(!gCrypt.InitializeCryptographySet(CRYPTKEY, strlen(CRYPTKEY), CRYPTFLAGS))
	{
        WriteSysLog("Failed to Initialize Cryptography Set CSockSrvr.\n");
        return false;
	}

	if(!GetRegistryValues())
	{
		MessageBox(GetActiveWindow(), "Failed to get registry values.", gsTitleCaption, 0);
        return false;
	}

	if(!OpenLogFile())
	{
		MessageBox(GetActiveWindow(), "Failed to open log file.", gsTitleCaption, 0);
	}

	if(!gServer.Initialize(25))
    {
        WriteSysLog("Failed to Initialize the CSockSrvr.\n");
        return false;
    }

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool UninitializeApp(void)
{
    SaveRegistryValues();

	if(!gServer.UnInitialize())
    {
        WriteSysLog("Failed to UnInitialize the CSockSrvr\n");

        return 0;
    }

	gCrypt.UninitializeCryptographySet();

	CloseLogFile();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
